definition module StdPSt


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.0.1
//	
//	StdPSt defines operations on PSt and IOSt that are not abstract device related.
//	********************************************************************************


import	StdFunc, StdFile
import	StdFileSelect, StdFont, StdIOCommon, StdTime
from	iostate import	PSt, IOSt


/*	PSt is an environment instance of the following classes:
	- FileEnv		(see StdFile)
	- FileSelectEnv	(see StdFileSelect)
	- FontEnv		(see StdFont)
	- TimeEnv		(see StdTime)
*/
instance FileEnv		(PSt .l .p)
instance FileSelectEnv	(PSt .l .p)
instance FontEnv		(PSt .l .p)
instance TimeEnv		(PSt .l .p)


beep :: !(IOSt .l .p) -> IOSt .l .p
/*	beep emits the alert sound.
*/


//	Operations on the global cursor:

/* RWS ---
setCursor		:: !CursorShape !(IOSt .l .p) -> IOSt .l .p
resetCursor		::              !(IOSt .l .p) -> IOSt .l .p
obscureCursor	::              !(IOSt .l .p) -> IOSt .l .p
/*	setCursor		overrules the shape of the cursor of all windows. 
	resetCursor		removes the overruled cursor shape of all windows.
	obscureCursor	hides the cursor until the mouse is moved.
*/


//	Operations on the DoubleDownDistance:

setDoubleDownDistance :: !Int !(IOSt .l .p) -> IOSt .l .p
/*	setDoubleDownDistance sets the maximum distance the mouse is allowed to move to 
	generate a ButtonDouble(Triple)Down button state. Negative values are set to 
	zero.
*/
--- RWS */

//	Operations on the DocumentInterface of an interactive process:

getDocumentInterface :: !(IOSt .l .p) -> (!DocumentInterface, !IOSt .l .p)
/*	getDocumentInterface returns the DocumentInterface of the interactive process.
*/


//	Operations on the attributes of an interactive process:

setProcessActivate	:: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessDeactivate:: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessHelp		:: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessAbout		:: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
/*	These functions set the ProcessActivate, ProcessDeactivate, ProcessHelp, and 
	ProcessAbout attribute of the interactive process respectively.
*/


//	Coercing PSt component operations to PSt operations.

appListPIO	:: ![.IdFun (IOSt .l .p)]	!(PSt .l .p) ->			 PSt .l .p
appListPLoc	:: ![.IdFun .l]				!(PSt .l .p) ->			 PSt .l .p
appListPPub	:: ![.IdFun .p]				!(PSt .l .p) ->			 PSt .l .p

appPIO		:: !.(IdFun (IOSt .l .p))	!(PSt .l .p) ->			 PSt .l .p
appPLoc		:: !.(IdFun .l)				!(PSt .l .p) ->			 PSt .l .p
appPPub		:: !.(IdFun .p)				!(PSt .l .p) ->			 PSt .l .p

//	Accessing PSt component operations.

accListPIO	:: ![.St (IOSt .l .p) .x]	!(PSt .l .p) -> (![.x],	!PSt .l .p)
accListPLoc	:: ![.St .l           .x]	!(PSt .l .p) -> (![.x],	!PSt .l .p)
accListPPub	:: ![.St .p           .x]	!(PSt .l .p) -> (![.x],	!PSt .l .p)

accPIO		:: !.(St (IOSt .l .p) .x)	!(PSt .l .p) -> (!.x,	!PSt .l .p)
accPLoc		:: !.(St .l           .x)	!(PSt .l .p) -> (!.x,	!PSt .l .p)
accPPub		:: !.(St .p           .x)	!(PSt .l .p) -> (!.x,	!PSt .l .p)
